/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.fluid;

import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.graph.NetworkGraphScannerResult;
import com.refinedmods.refinedpipes.network.pipe.Destination;
import com.refinedmods.refinedpipes.network.pipe.DestinationType;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipe;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipeType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidNetwork
extends Network {
    private final FluidTank fluidTank = new FluidTank(1000);
    private final FluidPipeType pipeType;

    public FluidNetwork(BlockPos originPos, String id, FluidPipeType pipeType) {
        super(originPos, id);
        this.pipeType = pipeType;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    public NetworkGraphScannerResult scanGraph(Level level, BlockPos pos) {
        NetworkGraphScannerResult result = super.scanGraph(level, pos);
        this.fluidTank.setCapacity(result.getFoundPipes().stream().filter(p -> p instanceof FluidPipe).mapToInt(p -> ((FluidPipe)p).getType().getCapacity()).sum());
        if (this.fluidTank.getFluidAmount() > this.fluidTank.getCapacity()) {
            this.fluidTank.getFluid().setAmount(this.fluidTank.getCapacity());
        }
        return result;
    }

    @Override
    public void update(Level level) {
        super.update(level);
        List<Destination> destinations = this.graph.getDestinations(DestinationType.FLUID_HANDLER);
        if (this.fluidTank.getFluid().isEmpty() || destinations.isEmpty()) {
            return;
        }
        for (Destination destination : destinations) {
            FluidStack toOffer;
            IFluidHandler handler;
            BlockEntity blockEntity = destination.getConnectedPipe().getLevel().m_7702_(destination.getReceiver());
            if (blockEntity == null || (handler = (IFluidHandler)blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, destination.getIncomingDirection().m_122424_()).orElse(null)) == null) continue;
            int toOfferAmount = Math.min(this.pipeType.getTransferRate(), this.fluidTank.getFluidAmount());
            if (toOfferAmount <= 0 || (toOffer = this.fluidTank.drain(toOfferAmount, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) break;
            int accepted = handler.fill(toOffer, IFluidHandler.FluidAction.EXECUTE);
            int remainder = toOffer.getAmount() - accepted;
            if (remainder <= 0) continue;
            FluidStack remainderStack = toOffer.copy();
            remainderStack.setAmount(remainder);
            this.fluidTank.fill(remainderStack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void onMergedWith(Network mainNetwork) {
        ((FluidNetwork)mainNetwork).getFluidTank().fill(this.fluidTank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public ResourceLocation getType() {
        return this.pipeType.getNetworkType();
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.m_128365_("tank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        return super.writeToNbt(tag);
    }
}

